library(deSolve)

# definition of derivatives for the Lotka-Volterra model
dN_dt = function(t,N,parms)
  {
  dN1_dt = with(parms,r1*N[1]*(1-(N[1]+alpha_12*N[2])/K1))
  dN2_dt = with(parms,r2*N[2]*(1-(N[2]+alpha_21*N[1])/K2))
  return(list(c(dN1_dt,dN2_dt)))
  }

# set parameter values
parms = list(r1=1.2, r2=0.8, K1=6, K2=10, alpha_12=0.4,
             alpha_21=1)

# set initial conditions and time points to evaluate the
# population sizes
N0 = c(4,4)
dt = 0.1
ts=seq(0,50,dt)

# run the differential equation solver to get time series
N_t = ode(N0,ts,dN_dt,parms=parms)

# draw the time series
plot(ts,N_t[,2],xlab='t',ylab='N',col='blue',type='l',
     ylim=c(0,12))
lines(ts,N_t[,3],col='red',type='l') 
